import java.net.*;
import java.io.*;

public class EchoServerNetThread extends Thread
{
  protected ServerSocket serverSocket = null;
  protected EchoServerConsole escon;
  protected int port;
  public EchoServerNetThread(EchoServerConsole escon, int port)
  {
    this.escon = escon;
    this.port = port;
  }
  public void run()
  {
    Socket socket = null;
    try{
      serverSocket = new ServerSocket(port);
    }
    catch(IOException e){
      escon.log(
        "Bd przy tworzeniu gniazda serwerowego " + e);
      return;
    }
    escon.log("Inicjalizacja gniazda zakoczona...");
    escon.log("Parametry gniazda: " + serverSocket);
    while(true){
      try{
        socket = serverSocket.accept();
      }
      catch(IOException e){
        escon.log("Bd wejcia-wyjcia: " + e);
        return;
      }
      escon.log("Nadeszo poczenie...");
      escon.log("Parametry poczenia: " + socket);
      EchoServerCommThread thread = 
        new EchoServerCommThread(escon, socket);
      escon.addThread(thread);
      thread.start();
    }
  }
  public void interrupt()
  {
    super.interrupt();
    try{
      serverSocket.close();
    }
    catch(IOException e){}
  }
}
